library(tidyverse)
library(stringi)
library(magrittr)

#m <- get_matrix(.as_matrix = TRUE, .combine_years = TRUE, .is_all_countries = TRUE)
fst_vals <- read.csv("fst_values.csv")
m <- as.matrix(fst_vals[,c(2:81)])
row.names(m) <- fst_vals$X 
colnames(m) <- fst_vals$X

#Uncomment the scale you want to create
scale <- "weird"
#scale <- "sino"

if (scale=="weird") {
  .comparison_country <- "United States"
  
} else if (scale=="sino") {
  .comparison_country <- "China"
}

# Plots title
.title <- sprintf("National fst values vs. %s", .comparison_country)

# Creates Fst values
country.fst <- m %>%
  as.data.frame() %>%
  mutate(country_1 = rownames(as.data.frame(m))) %>%
  gather(country_2, fst_vs_NE, -country_1) %>%
  na.omit()

country.fst %<>%
  filter(country_1 == .comparison_country | country_2 == .comparison_country)

country.fst$country_2 = stri_replace_all_regex(country.fst$country_2, "\\.", " ")

country.fst <-
  data.frame(country_1 = .comparison_country,
             country_2 = .comparison_country,
             fst_vs_NE = 0) %>%
  bind_rows(country.fst)

tmp <- country.fst[country.fst$country_2 == .comparison_country, ]$country_1
if (length(tmp) > 0) {
  country.fst[country.fst$country_2 == .comparison_country, ]$country_1 <- .comparison_country
  country.fst[country.fst$country_2 == .comparison_country, ]$country_2 <- tmp
}

country.fst %<>%
  select(country = country_2, x = fst_vs_NE) %>%
  distinct()

# Prepares data for plotting
signed_runif <- function(n) {
  sign <- ifelse(1:n %% 2 == 1, 1, -1)
  pmax(runif(n), 0.2) * sign
}

country.fst %<>%
  arrange(x) %>%
  mutate(y = signed_runif(nrow(country.fst))) %>%
  separate(country, c("iso", "region"), sep = ":", remove = FALSE, extra = "drop", fill = "right")

# Plotting
if (nrow(country.fst) > 0) {
  
  .breaks <- seq(floor(min(country.fst$x) * 100) / 100,
                 ceiling(max(country.fst$x) * 100) / 100,
                 length.out = 10)
  .breaks <- round(.breaks * 100) / 100
  
  if (all(is.na(country.fst$region))) {
    country.fst$iso <- "default"
  }
  
  p <- ggplot(data = country.fst) +
    geom_segment(aes(x = x, y = y, xend = x, yend = 0), size = 0.8) +
    geom_text(aes(x = x, y = y*1.05, label = country), angle = 45, check_overlap = FALSE, size = 8) +
    geom_hline(yintercept = 0, color = "darkblue") +
    ggtitle(.title) +
    theme_light() +
    theme(panel.border = element_blank(),
          panel.grid.major = element_blank(),
          axis.text = element_text(size = 22),
          legend.position = "none",
          plot.title = element_blank(),
          axis.line.x = element_line(size = 0.5)) +
    scale_y_continuous(breaks = 0, labels = NULL, limits = c(-1.1, 1.1)) +
    scale_x_continuous(breaks = .breaks) +
    ylab("") +
    xlab("")
  p
  
} else {
  
  # Empty plot
  ggplot() +
    geom_text(aes(x = 1, y = 1, label = "Plot missing. Not enough data for this selection.")) +
    ggtitle(.title) +
    theme_nothing(legend = TRUE)
}
p


if (scale=="weird") {
  ggsave(filename = "weird_scale.png", plot = p, width = 30, height = 10)
  
} else if (scale=="sino") {
  ggsave(filename = "sino_scale.png", plot = p, width = 30, height = 10)
}

