library(tidyverse)
library(cowplot)
library(ggrepel)
library(ggsci)

dat <- read.csv("weird_sino.csv")

continents <- read.csv("Countries_continents.csv")

dat <- merge(dat, continents, by="country")

dat$United.States[dat$country == "United States"] <- NA
dat$China[dat$country == "China"] <- NA

ggplot(dat, aes(x = United.States, y = China)) +
  geom_point(aes(color = continent2), size = 3) +
  geom_text_repel(aes(label = country), alpha=0.7, size = 3) + 
  theme_classic() +
  scale_color_lancet(name="Region") +
  labs(x = "Distance from United States", y = "Distance from China")

ggsave(file = "usa-china-2d.png", height = 8, width = 8, units = "in")
