library(foreign)
library(dplyr)
library(Hmisc)
library(stringr)

####FUNCTIONS####
source( file="CultureFst.r")

#################

wvs <- read.csv("wvs_allelesv02_merged.csv")

dimensions <- read.csv("allele-dimensions-datavv02.csv")
include_vars <- as.character(dimensions[dimensions$CAT.All==1,]$V)

wvs <- wvs[,(names(wvs) %in% include_vars | names(wvs) %in% c("S002", "S003", "X048WVS"))]
wvs$pop <- wvs$S003

#Move pop to the front
col_idx <- grep("pop", names(wvs))
wvs <- wvs[, c(col_idx, (1:ncol(wvs))[-col_idx])]

wvs.rep_subset <- wvs[str_detect(wvs$S002,"^2005") | str_detect(wvs$S002,"^2010"),]
wvs.rep_subset[wvs.rep_subset<0] <- NA

loci <- ls(wvs.rep_subset)
loci <- loci[loci != "X048WVS"]
loci <- loci[loci != "pop"]
loci <- loci[loci != "Region"]
loci <- loci[loci != "S002"]
loci <- loci[loci != "S003"]
# what is the type of data, discrete (0) or continuous (1)
type <- c(0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	1, 	1, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	0 )
names(type) <- loci # make sure to give names to elements of this vector


# run fst function with bootstrap
#ans.fst = CultureFst( wvs.rep_subset, loci, type, bootstrap=TRUE, no.samples=100, label="test_ex_boot")
# run fst function without bootstrap
ans.fst = CultureFst( wvs.rep_subset, loci, type, bootstrap=FALSE, no.samples=100, label="test_ex")

write.csv(ans.fst$mean.fst, "fst_values.csv")
